unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ExtCtrls, StdCtrls,
  UConsts, USg, Buttons, ActnList, Menus, XPMan;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    sg: TStringGrid;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    PopupMenu1: TPopupMenu;
    ActionList1: TActionList;
    ActionInsert: TAction;
    ActionEdit: TAction;
    ActionDelete: TAction;
    ActionKoniec: TAction;
    Koniec1: TMenuItem;
    INsert1: TMenuItem;
    Edit1: TMenuItem;
    Delete1: TMenuItem;
    XPManifest1: TXPManifest;
    procedure ActionKoniecExecute(Sender: TObject);
    procedure ActionDeleteExecute(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
    procedure ActionInsertExecute(Sender: TObject);
    procedure sgClick(Sender: TObject);
    procedure sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure sgSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
    procedure FormShow(Sender: TObject);

  private
	 mSelected : Boolean;
	 cbWoj     : TComboBox;

	 procedure  DrawRectGrid(Rect : TRect);
	 procedure  cbWojChange(Sender : TObject);
	 procedure  set_cbWoj(txt : String);
    procedure  Rysuj_cbWoj();

	 procedure  Przypisz_lp();

  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   mSelected := false;

   cbWoj          := TComboBox.Create(Nil);
   cbWoj.Parent   := self;
   cbWoj.Visible  := false;
	cbWoj.Style    := csDropDown;
   cbWoj.OnChange := cbWojChange;

   cbWoj.Clear();

   cbWoj.Items.Add('dolnolskie');
   cbWoj.Items.Add('kujawsko-pomorskie');
   cbWoj.Items.Add('lubelskie');
   cbWoj.Items.Add('lubuskie');
   cbWoj.Items.Add('dzkie');
   cbWoj.Items.Add('maopolskie');
   cbWoj.Items.Add('mazowieckie');
   cbWoj.Items.Add('opolskie');
   cbWoj.Items.Add('podkarpackie');
   cbWoj.Items.Add('podlaskie');
   cbWoj.Items.Add('pomorskie');
   cbWoj.Items.Add('lskie');
   cbWoj.Items.Add('witokrzyskie');
   cbWoj.Items.Add('warmisko-mazurskie');
   cbWoj.Items.Add('wielkopolskie');
   cbWoj.Items.Add('zachodniopomorskie');
end;

procedure TMainForm.Przypisz_lp();
var
	ARow          : Integer;
   ACol          : Integer;
   ilosc_wierszy : Integer;
   lp            : Integer;

begin
	ARow          := 0;
   ACol          := 0;
   ilosc_wierszy := 0;
   lp            := 0;
	ARow          := 0;

   ilosc_wierszy := sg.RowCount;

	for ARow := 1 to ilosc_wierszy-1 do
	begin
   	sg.Cells[ACol, ARow] := IntToStr(ARow);
   end;

   sg.Invalidate();
end;

procedure TMainForm.Rysuj_cbWoj();
var
	Rect : TRect;

begin
	Rect := sg.CellRect(sg.Col, sg.Row);

   cbWoj.Visible := false;

   cbWoj.Top     := sg.Top + Rect.Top + sg.GridLineWidth;
   cbWoj.Left    := sg.Left + Rect.Left + sg.GridLineWidth;
   cbWoj.Height  := (Rect.Bottom - Rect.Top) + 1;
   cbWoj.Width   := (Rect.Right - Rect.Left) + 1;

   cbWoj.Visible := true;
end;

procedure TMainForm.set_cbWoj(txt: String);
var
	ilEL : Integer;
	lp   : Integer;
   txt2 : String;

begin
	// ustawia cxbWoj.Text na to co jest aktualnie w celi
	ilEl := cbWoj.Items.Count - 1;

   if ilEl < 0 then
   begin
		exit;
   end;

	lp   := 0;
	txt2 := '';

	cbWoj.ItemIndex := -1;
   for lp := 0 to ilEl do
   begin
		txt2 := cbWoj.Items.Strings[lp];

      if (txt = txt2) then
   	begin
			cbWoj.ItemIndex := lp;
      end;
   end;
end;

procedure TMainForm.sgClick(Sender: TObject);
var
	txt  : String;
   ARow : Integer;
	ACol : Integer;

begin
	if sg.Col = colWoj then
   begin
		txt  := '';
      ARow := sg.Row;
      ACol := sg.Col;

      txt := sg.Cells[ACol, ARow];

      // ustaw cbWoj na to co jest w Celi
      set_cbWoj(txt);

      Rysuj_cbWoj();
      cbWoj.DroppedDown := false;
   end
   else begin
	   cbWoj.Visible := false;
   end;
end;

procedure TMainForm.sgSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
begin
	mSelected := true;
end;

procedure TMainForm.sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
var
	inny_kolor : Boolean;
   txt        : String;
	x          : Integer;
	y          : Integer;

begin
	inny_kolor := false;
	txt        := '';
	x          := 0;
	y          := 0;

	if (ARow = 0) or (ACol = 0) then
   begin
		exit;
   end;

   // co drugi rzd w innym kolorze
	inny_kolor := (ARow mod 2) = 0;

	// ramka wok aktywnej celi
   if gdFocused in State then
   begin
		DrawRectGrid(Rect);
   end;

   // co drugi wiersz w innym kolorze
   if inny_kolor then
   begin
	   if not (gdFocused in State) then
   	begin
      	txt := sg.Cells[ACol, ARow];

			// kolor niestandardowy
         sg.Canvas.Brush.Color := TColor($00D6EAEF);

         sg.Canvas.FillRect(Rect);

         x := Rect.Left + 2;
         y := (Rect.Top + Rect.Bottom - sg.Canvas.TextHeight(txt)) div 2;
         sg.Canvas.TextOut(x, y, txt);
      end;
   end;
end;

procedure TMainForm.DrawRectGrid(Rect : TRect);
begin
	if mSelected then
   begin
		sg.Repaint();
      mSelected := false;
   end;

   sg.Canvas.Brush.Style := bsClear;
   sg.Canvas.Pen.Color   := clBlue;
   sg.Canvas.Pen.Width   := 2;
   sg.Canvas.Rectangle(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
end;

procedure TMainForm.cbWojChange(Sender: TObject);
begin
	sg.Cells[sg.Col, sg.Row] := cbWoj.Items.Strings[cbWoj.ItemIndex];
   cbWoj.Visible := false;
end;

procedure TMainForm.ActionDeleteExecute(Sender: TObject);
begin
	ShowMessage('Akcja Delete');
end;

procedure TMainForm.ActionEditExecute(Sender: TObject);
begin
	ShowMessage('Akcja Edit');
end;

procedure TMainForm.ActionInsertExecute(Sender: TObject);
begin
	ShowMessage('Akcja Insert');
end;

procedure TMainForm.ActionKoniecExecute(Sender: TObject);
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	ob : MSg;

begin
	sg.Align := alClient;

	ob := MSg.Create(sg);
   ob.Wypelnij();
   FreeAndNil(ob);

   ActiveControl := sg;
end;

end.
